/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.betterx.betternether.entity.EntityFirefly;
import org.betterx.betternether.entity.model.ModelEntityFirefly;
import org.betterx.betternether.entity.render.RenderPhaseAccessor;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

class FireflyGlowFeatureRenderer
extends RenderLayer<EntityFirefly, AgeableListModel<EntityFirefly>> {
    private static final int LIT = 0xF000F0;

    public FireflyGlowFeatureRenderer(RenderLayerParent<EntityFirefly, AgeableListModel<EntityFirefly>> featureRendererContext) {
        super(featureRendererContext);
    }

    public void render(PoseStack matrices, MultiBufferSource vertices, int light, EntityFirefly livingEntity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        EntityModel model = this.m_117386_();
        if (model instanceof ModelEntityFirefly) {
            ResourceLocation identifier = this.m_117347_((Entity)livingEntity);
            RenderType renderLayer = RenderPhaseAccessor.getFirefly(identifier);
            VertexConsumer vertexConsumer = vertices.m_6299_(renderLayer);
            float red = livingEntity.getRed();
            float green = livingEntity.getGreen();
            float blue = livingEntity.getBlue();
            this.addViewAlignedGlow(matrices, vertexConsumer, red, green, blue);
            ((ModelEntityFirefly)model).getGlowPart().m_104306_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, red * 2.0f, green * 2.0f, blue * 2.0f, 1.0f);
            ((ModelEntityFirefly)model).getGlowPart().m_104306_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, red * 2.0f, green * 2.0f, blue * 2.0f, 1.0f);
        }
    }

    private void addViewAlignedGlow(PoseStack matrices, VertexConsumer vertexConsumer, float red, float green, float blue) {
        matrices.m_85836_();
        matrices.m_85837_(0.0, 1.25, 0.0);
        Matrix3f normalMatrix = matrices.m_85850_().m_252943_();
        normalMatrix.transpose();
        matrices.m_252781_(normalMatrix.transpose(new Matrix3f()).getNormalizedRotation(new Quaternionf()));
        PoseStack.Pose entry = matrices.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        FireflyGlowFeatureRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, -1.0f, -1.0f, 0.0f, 0.5f, red, green, blue);
        FireflyGlowFeatureRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, 1.0f, -1.0f, 1.0f, 0.5f, red, green, blue);
        FireflyGlowFeatureRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, 1.0f, 1.0f, 1.0f, 1.0f, red, green, blue);
        FireflyGlowFeatureRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, -1.0f, 1.0f, 0.0f, 1.0f, red, green, blue);
        matrices.m_85849_();
    }

    public static void addVertex(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertexConsumer, float posX, float posY, float u, float v, float red, float green, float blue) {
        vertexConsumer.m_252986_(matrix4f, posX, posY, 0.0f).m_85950_(red, green, blue, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

